VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "Msflxgrd.ocx"
Begin VB.Form HSDigIn 
   BackColor       =   &H80000004&
   Caption         =   "High Speed DI with KPCI-3100 Series"
   ClientHeight    =   5385
   ClientLeft      =   1755
   ClientTop       =   2145
   ClientWidth     =   8130
   ForeColor       =   &H00000000&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   5385
   ScaleWidth      =   8130
   Begin VB.CommandButton cmdUpdate 
      Caption         =   "&Update Grid"
      Height          =   495
      Left            =   5400
      TabIndex        =   51
      Top             =   3720
      Width           =   1215
   End
   Begin MSFlexGridLib.MSFlexGrid Grid1 
      Height          =   3255
      Left            =   3960
      TabIndex        =   50
      Top             =   360
      Width           =   4095
      _ExtentX        =   7223
      _ExtentY        =   5741
      _Version        =   393216
      FixedRows       =   0
   End
   Begin VB.TextBox TBRdg 
      Height          =   285
      Left            =   1800
      TabIndex        =   47
      Top             =   360
      Width           =   1095
   End
   Begin VB.TextBox TBBufferSize 
      BackColor       =   &H8000000F&
      Enabled         =   0   'False
      Height          =   285
      Left            =   960
      TabIndex        =   46
      Top             =   3960
      Width           =   1215
   End
   Begin VB.TextBox TBAvg 
      Height          =   285
      Left            =   2520
      TabIndex        =   43
      Top             =   4560
      Width           =   1215
   End
   Begin VB.TextBox TBDataLost 
      Height          =   285
      Left            =   960
      TabIndex        =   41
      Text            =   "0"
      Top             =   4560
      Width           =   1215
   End
   Begin VB.TextBox TBBuffers 
      Height          =   285
      Left            =   2520
      TabIndex        =   39
      Text            =   "0"
      Top             =   3960
      Width           =   1215
   End
   Begin VB.TextBox b14 
      Height          =   285
      Left            =   1320
      TabIndex        =   38
      Top             =   1320
      Width           =   255
   End
   Begin VB.TextBox b0 
      Height          =   285
      Left            =   3480
      TabIndex        =   19
      Top             =   2040
      Width           =   255
   End
   Begin VB.TextBox b1 
      Height          =   285
      Left            =   3120
      TabIndex        =   18
      Top             =   2040
      Width           =   255
   End
   Begin VB.TextBox b2 
      Height          =   285
      Left            =   2760
      TabIndex        =   17
      Top             =   2040
      Width           =   255
   End
   Begin VB.TextBox b3 
      Height          =   285
      Left            =   2400
      TabIndex        =   16
      Top             =   2040
      Width           =   255
   End
   Begin VB.TextBox b4 
      Height          =   285
      Left            =   2040
      TabIndex        =   15
      Top             =   2040
      Width           =   255
   End
   Begin VB.TextBox b5 
      Height          =   285
      Left            =   1680
      TabIndex        =   14
      Top             =   2040
      Width           =   255
   End
   Begin VB.TextBox b6 
      Height          =   285
      Left            =   1320
      TabIndex        =   13
      Top             =   2040
      Width           =   255
   End
   Begin VB.TextBox b7 
      Height          =   285
      Left            =   960
      TabIndex        =   12
      Top             =   2040
      Width           =   255
   End
   Begin VB.TextBox b8 
      Height          =   285
      Left            =   3480
      TabIndex        =   11
      Top             =   1320
      Width           =   255
   End
   Begin VB.TextBox b9 
      Height          =   285
      Left            =   3120
      TabIndex        =   10
      Top             =   1320
      Width           =   255
   End
   Begin VB.TextBox b10 
      Height          =   285
      Left            =   2760
      TabIndex        =   9
      Top             =   1320
      Width           =   255
   End
   Begin VB.TextBox b11 
      Height          =   285
      Left            =   2400
      TabIndex        =   8
      Top             =   1320
      Width           =   255
   End
   Begin VB.TextBox b12 
      Height          =   285
      Left            =   2040
      TabIndex        =   7
      Top             =   1320
      Width           =   255
   End
   Begin VB.TextBox b13 
      Height          =   285
      Left            =   1680
      TabIndex        =   6
      Top             =   1320
      Width           =   255
   End
   Begin VB.TextBox b15 
      Height          =   285
      Left            =   960
      TabIndex        =   5
      Top             =   1320
      Width           =   255
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "S&top"
      Height          =   492
      Left            =   5400
      TabIndex        =   2
      Top             =   4440
      Width           =   1212
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   492
      Left            =   6840
      TabIndex        =   1
      Top             =   4440
      Width           =   1212
   End
   Begin VB.CommandButton cmdAcquire 
      Caption         =   "&Start"
      Default         =   -1  'True
      Height          =   492
      Left            =   3960
      TabIndex        =   0
      Top             =   4440
      Width           =   1212
   End
   Begin DlsrLib.DriverLINXLDD DriverLINXLDD1 
      Left            =   3840
      Top             =   3840
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   4440
      Top             =   3840
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label29 
      Alignment       =   2  'Center
      Caption         =   "Data Buffer Grid"
      Height          =   255
      Left            =   4080
      TabIndex        =   52
      Top             =   120
      Width           =   3975
   End
   Begin VB.Label Label24 
      Alignment       =   2  'Center
      Caption         =   "Digital Input Data"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1080
      TabIndex        =   49
      Top             =   840
      Width           =   2535
   End
   Begin VB.Label Label25 
      Alignment       =   2  'Center
      Caption         =   "Count Value"
      Height          =   255
      Left            =   1800
      TabIndex        =   48
      Top             =   120
      Width           =   1095
   End
   Begin VB.Label Label23 
      Alignment       =   2  'Center
      Caption         =   "Buffer Size"
      Height          =   255
      Left            =   960
      TabIndex        =   45
      Top             =   3720
      Width           =   1215
   End
   Begin VB.Label Label22 
      Alignment       =   2  'Center
      Caption         =   "Avg Rdgs (MHz)"
      Height          =   255
      Left            =   2520
      TabIndex        =   44
      Top             =   4320
      Width           =   1215
   End
   Begin VB.Label Label21 
      Alignment       =   2  'Center
      Caption         =   "Data Lost"
      Height          =   255
      Left            =   960
      TabIndex        =   42
      Top             =   4320
      Width           =   1215
   End
   Begin VB.Label Label20 
      Alignment       =   2  'Center
      Caption         =   "Buffers Filled"
      Height          =   255
      Left            =   2520
      TabIndex        =   40
      Top             =   3720
      Width           =   1215
   End
   Begin VB.Label Label19 
      Caption         =   "Channel A"
      Height          =   255
      Left            =   120
      TabIndex        =   37
      Top             =   2040
      Width           =   855
   End
   Begin VB.Label Label18 
      Caption         =   "Channel B"
      Height          =   255
      Left            =   120
      TabIndex        =   36
      Top             =   1320
      Width           =   855
   End
   Begin VB.Label Label17 
      Alignment       =   2  'Center
      Caption         =   "0"
      Height          =   255
      Left            =   3480
      TabIndex        =   35
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label Label16 
      Alignment       =   2  'Center
      Caption         =   "1"
      Height          =   255
      Left            =   3120
      TabIndex        =   34
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label Label15 
      Alignment       =   2  'Center
      Caption         =   "2"
      Height          =   255
      Left            =   2760
      TabIndex        =   33
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label Label14 
      Alignment       =   2  'Center
      Caption         =   "3"
      Height          =   255
      Left            =   2400
      TabIndex        =   32
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label Label13 
      Alignment       =   2  'Center
      Caption         =   "4"
      Height          =   255
      Left            =   2040
      TabIndex        =   31
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label Label12 
      Alignment       =   2  'Center
      Caption         =   "5"
      Height          =   255
      Left            =   1680
      TabIndex        =   30
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label Label11 
      Alignment       =   2  'Center
      Caption         =   "6"
      Height          =   255
      Left            =   1320
      TabIndex        =   29
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label Label10 
      Alignment       =   2  'Center
      Caption         =   "7"
      Height          =   255
      Left            =   960
      TabIndex        =   28
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      Caption         =   "8"
      Height          =   255
      Left            =   3480
      TabIndex        =   27
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      Caption         =   "9"
      Height          =   255
      Left            =   3120
      TabIndex        =   26
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "10"
      Height          =   255
      Left            =   2760
      TabIndex        =   25
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      Caption         =   "11"
      Height          =   255
      Left            =   2400
      TabIndex        =   24
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "12"
      Height          =   255
      Left            =   2040
      TabIndex        =   23
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "13"
      Height          =   255
      Left            =   1680
      TabIndex        =   22
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "14"
      Height          =   255
      Left            =   1320
      TabIndex        =   21
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   "15"
      Height          =   255
      Left            =   960
      TabIndex        =   20
      Top             =   1080
      Width           =   255
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Status "
      Height          =   195
      Left            =   210
      TabIndex        =   4
      Top             =   4800
      Width           =   480
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   315
      Left            =   180
      TabIndex        =   3
      Top             =   5040
      Width           =   5865
   End
End
Attribute VB_Name = "HSDigIn"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This example demonstrates how to acquire multiple buffers of data
' from your board's analog input subsystem.
' It performs seven DriverLINX operations:
'   1. Open a DriverLINX driver
'   2. Initialize a Logical Device
'   3. See if the Logical Device supports analog input
'   4. Setup the Service Request
'   5. Execute the Service Request
'   6. Process the results
'   7. Close the DriverLINX driver
'
' This application performs steps 1, 2, 3, 4, and 7 once. Every time
'   that you click the form's "Acquire" button, it performs steps 5.
'   It uses the DriverLINXSR bufferFilled event to know when to perform
'   step 6.
'
' Code for this example is divided between three modules:
'   AINONSTPForm, which you will find in the file, AINONSTP.frm,
'   DriverLINXGUIInterface, which you will find in DLVBGui.bas, and
'   DriverLINXLibrary, which you will find in the file DLVBLib.bas.
'
' To the extent possible, DriverLINXLibrary contains all
'   DriverLINX/VB-specific code.
'
' AINONSTPForm is organized as follows:
'
'   Form_Load() opens a DriverLINX driver, initializes a Logical Device,
'       and checks whether the Logical Device supports analog input.
'
'   Form_Load() then sets up a Service Request that, when executed, will
'       acquire multiple buffers of data from the Logical Device's
'       analog-input susbsystem.
'
'   cmdAcquire_Click() executes the Service Request setup by
'       Form_Load(), and displays the acquired value, along
'       with any error messages from DriverLINX.
'
'   DriverLINXSR1_ServiceStart() updates the form to indicate that a task
'       is currently running.
'
'   DriverLINXSR1_BufferFilled() retrieves data from the DriverLINXSR
'       control, and plots it on the form's CRT panel.
'
'   DriverLINXSR1_ServiceDone() updates the form to indicate that a task
'       has ended.
'
'   vscrollChannelSelector_Change() changes the Logical Channel by updating
'       the value of the Service Request's .Sel_chan_start property.
'
'   cmdStop_Click() stops any active DriverLINX task and clears the picture box.
'
'   cmdExit_Click() stops any active DriverLINX task by utilizing the cmdSTOP_Click event, and then closes the
'       DriverLINX driver opened in Form_Load().
'

' With the Option Explicit statement, VB will help catch typing errors
Option Explicit

Const CHAN_OEM_FLAG As Integer = (-2) ^ 15
Const CHAN_OEM_MASK = 127           'Use 127 for 3101/2/3/4, 3 for 3110/16
Const CHAN_OEM_SHIFT = 2 ^ 4
Const CHAN_SEDIFF_DIG As Integer = (2 ^ 13)

Dim startTimer As Long
Dim lastTimer As Long
Const LogicalDevice As Integer = 4  'DriverLINX Logical Device
Private LogicalChannel As Integer   'DriverLINX Logical Channel
Const ChannelGain As Single = -1#   'Gain setting for Logical Channel

Const SamplingFrequency As Single = 3000000     'Max for this app

' Number of buffers
Const NumberOfBuffers As Integer = 4

' Number of samples in a buffer
Const NumberOfSamples As Integer = 30000
    
'Number of Channels
Const NumberOfChannels = 1

' A data storage array
Dim DataArray(0 To 0, 0 To NumberOfSamples - 1) As Single
Dim ChannelList(0 To 63) As Integer
Dim ChannelGains(0 To 63) As Integer

' Status string
Private strStatus As String
' Status strings that indicate normal operation
Const msgRunning As String = "Running"
Const msgStopped As String = "Stopped"

Const BackGroundForeGround As Integer = 1     'IRQ or DMA = 1, Polled = 0


Private Sub cmdStop_Click()
 Dim DLStatusCode As Integer
    
    ' Make sure that there are no active tasks
    DLStatusCode = StopDriverLINXIO(DriverLINXSR1)
    
    ' If active task is found, do not exit until DriverLINX notifies
    '   you that it is really done.
    If DLStatusCode = DL_NoErr Then
     Do
            DoEvents
        Loop Until cmdAcquire.Enabled
    End If
     
     'disable the stop button until task is restarted
    cmdStop.Enabled = False
    
    'Clear the picture
    'pictureCRT.Cls
    TBBuffers.Text = 0
    TBDataLost.Text = 0
   
End Sub


Private Sub cmdUpdate_Click()
    Call UpdateGrid
End Sub

Private Sub DriverLINXSR1_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
    'Display Message
    lblStatus.Caption = "Data Lost"
    'Increment
    TBDataLost.Text = Val(TBDataLost.Text) + 1
    
    InitializeDriverLINXDevice DriverLINXSR1, LogicalDevice
    SetupDriverLINXContinuousBufferedIO DriverLINXSR1, DriverLINXLDD1, LogicalDevice, DL_AI, LogicalChannel, ChannelGain, SamplingFrequency, NumberOfSamples, NumberOfBuffers, BackGroundForeGround
    DriverLINXSR1.Sel_chan_N = 1
    DriverLINXSR1.Sel_chan_format = DL_tNATIVE
    DriverLINXSR1.Sel_chan_list(0) = 0
    DriverLINXSR1.Sel_chan_gainCodeList(0) = _
                                        CHAN_SEDIFF_DIG Or _
                                        DriverLINXSR1.DLGain2Code(-1)
    DriverLINXSR1.Refresh
End Sub

Private Sub Form_Load()

    Dim DLDriverName As String
    Dim DLResultCode As Integer
    Dim DLMessage As String
    Dim channelNumber As Integer
    Dim Model As String
    Dim Msg As String
    Dim i As Integer
    
    ' Make sure that this form is centered on the screen
    CenterForm Me
    
    'Disable the stop button until a task has been started
    cmdStop.Enabled = False
    TBBufferSize.Text = NumberOfSamples
    
    ' 1. Open a DriverLINX Driver
    DLDriverName = OpenDriverLINXDriver(DriverLINXSR1, "KPCI3100", True)
    If DLDriverName = "" Then
        ' If no driver opened, report this in a message box.
        MsgBox "DriverLINX driver not opened.", vbOKOnly, Me.Name
        
        ' Then close the application
        End
    End If
    
    ' 2. Initialize a Logical Device
    DLResultCode = InitializeDriverLINXDevice(DriverLINXSR1, LogicalDevice)
    If DLResultCode <> DL_NoErr Then
        ' If initialization fails, report the error in a message box
        ShowDriverLINXStatus DriverLINXSR1
        
        ' Then close the application
        End
    End If
    
    'Get Model name may be needed for messages
    Model = GetModelName(DriverLINXSR1, DriverLINXLDD1)
    
    ' 3. See if the Logical Device supports an analog-input subsystem
    If Not HasDriverLINXSubsystem(DriverLINXSR1, DriverLINXLDD1, DL_AI) Then
        ' If it does not, report this in a message box.
        Msg = "This " & Model & " does not support analog input"
        MsgBox Msg, vbOKOnly, Me.Name
        ' Then close the application
        End
    End If

    ' If initialization succeeded, report the success on the form
    GetDriverLINXStatus DriverLINXSR1, DLMessage
    lblStatus.Caption = DLMessage
    
   ' Scale form's CRT panel
    'InitCRT pictureCRT, FullSweep, 20, Digital, YAxisOffset
                                 'scale graph for 20 volts
    
    Call InitGrid
    
    ' 4. Setup the Service Request control for Multiple-buffer, single channel, continuous analog input
    SetupDriverLINXContinuousBufferedIO DriverLINXSR1, DriverLINXLDD1, LogicalDevice, DL_AI, LogicalChannel, ChannelGain, SamplingFrequency, NumberOfSamples, NumberOfBuffers, BackGroundForeGround
    
    'To hit 3 MHz we can only have one channel in the channel gain list, so it's commented out.
    'Call AddChannelGainList(DriverLINXSR1, DL_AI, 1, ChannelList, ChannelGains)
    
    DriverLINXSR1.Sel_chan_N = 1
    DriverLINXSR1.Sel_chan_format = DL_tNATIVE
    DriverLINXSR1.Sel_chan_list(0) = 0
    DriverLINXSR1.Sel_chan_gainCodeList(0) = _
                                        CHAN_SEDIFF_DIG Or _
                                        DriverLINXSR1.DLGain2Code(-1)

    'DriverLINXSR1.Refresh
    ' See CmdAcquire_Click( ) for how to start this task and process data
    
End Sub


Private Sub cmdAcquire_Click()

    Dim DLMessage As String
    Dim DLResultCode As Integer
    
    ' 5. Execute the Service Request specified when this
    '    form loaded. (See Form_Load( ) for details.)
    DriverLINXSR1.Refresh
    ' NOTE: Bufered I/O tasks execute asynchronously, i.e., the data
    '       is not available when the call to the Refresh method
    '       returns. To process results from buffered I/O tasks, handle
    '       events from the DriverLINXSR control. In this example, see
    '       the following subroutines:
    '           DriverLINXSR1_ServiceStart,
    '           DriverLINXSR1_BufferFilled, and
    '           DriverLINXSR1_ServiceDone.
    
    ' Display status or error information in this form's status box
    DLResultCode = GetDriverLINXStatus(DriverLINXSR1, DLMessage)
    If DLResultCode <> DL_NoErr Then
        strStatus = DLMessage
    End If
    
    lblStatus.Caption = strStatus
    
End Sub


Private Sub DriverLINXSR1_ServiceStart(task As Integer, device As Integer, subsystem As Integer, mode As Integer)

    ' The DriverLINXSR calls this subroutine when a task starts. This
    '   application uses this ServiceStart event to update the form,
    '   indicating that a task is currently running.
    strStatus = msgRunning
    lblStatus.Caption = strStatus
    
    ' Disable the start button while a task is running
    cmdAcquire.Enabled = False
    cmdStop.Enabled = True
    cmdUpdate.Enabled = False
    startTimer = Timer
    
End Sub


Private Sub DriverLINXSR1_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
    
    Dim samples As Long
        
    ' 6. Process results:
    '    Because buffered I/O tasks execute asynchronously, your
    '    application will not have any data to process until your
    '    DriverLINXSR control informs it that a buffer has filled.
    '    When you set the DriverLINXSR property, Sel_buf_notify, equal
    '    to DL_NOTIFY, the DriverLINXSR control calls this subroutine
    '    whenever it has filled a buffer with new data. At this point,
    '    you can transfer the data in this buffer from the DriverLINXSR
    '    control to an array defined in your application.
    samples = GetDriverLINXAIBuffer(DriverLINXSR1, bufIndex, DataArray())
                
    ' Display the new data
    ' ShowAnalogResults pictureCRT, NumberOfChannels, NumberOfSamples, SamplingFrequency, DataArray()
    'lblStatus.Caption = "Buffer " & bufIndex
    TBBuffers.Text = Val(TBBuffers.Text) + 1
    If Val(TBBuffers.Text) Mod 10 = 0 Then
        TBAvg.Text = CLng(NumberOfSamples * (Val(TBBuffers.Text) / (Timer - startTimer))) / 10 ^ 6
        PopulateData 0
        lastTimer = Timer
    End If
    
End Sub


Private Sub DriverLINXSR1_ServiceDone(task As Integer, device As Integer, subsystem As Integer, mode As Integer)

    ' The DriverLINXSR calls this subroutine when a task ends. This
    '   application uses this ServiceDone event to update the form,
    '   indicating that no task is running.
    strStatus = msgStopped
    lblStatus.Caption = strStatus
    
    ' Reenable the start button when a task ends.
    cmdAcquire.Enabled = True
    cmdUpdate.Enabled = True
    
End Sub


Private Sub cmdExit_Click()
   
   'Make sure there are no active task
   cmdStop_Click
            
    ' 7. Close the DriverLINX Driver
    CloseDriverLINXDriver DriverLINXSR1
    
    ' Quit this application
    Unload Me
End Sub


Private Sub Form_Terminate()
End     'Terminate the application
End Sub


Private Sub PopulateData(sample As Integer)
    
    TBRdg.Text = DriverLINXSR1.DLVolts2Code(DataArray(0, sample))

    If (TBRdg.Text And (-2) ^ 15) Then b15.Text = 1 Else b15.Text = 0 '(TBRdg.Text And (-2) ^ 15) / ((-2) ^ 15)
    b14.Text = (TBRdg.Text And 2 ^ 14) / 2 ^ 14
    b13.Text = (TBRdg.Text And 2 ^ 13) / 2 ^ 13
    b12.Text = (TBRdg.Text And 2 ^ 12) / 2 ^ 12
    b11.Text = (TBRdg.Text And 2 ^ 11) / 2 ^ 11
    b10.Text = (TBRdg.Text And 2 ^ 10) / 2 ^ 10
    b9.Text = (TBRdg.Text And 2 ^ 9) / 2 ^ 9
    b8.Text = (TBRdg.Text And 2 ^ 8) / 2 ^ 8
    b7.Text = (TBRdg.Text And 2 ^ 7) / 2 ^ 7
    b6.Text = (TBRdg.Text And 2 ^ 6) / 2 ^ 6
    b5.Text = (TBRdg.Text And 2 ^ 5) / 2 ^ 5
    b4.Text = (TBRdg.Text And 2 ^ 4) / 2 ^ 4
    b3.Text = (TBRdg.Text And 2 ^ 3) / 2 ^ 3
    b2.Text = (TBRdg.Text And 2 ^ 2) / 2 ^ 2
    b1.Text = (TBRdg.Text And 2 ^ 1) / 2 ^ 1
    b0.Text = (TBRdg.Text And 2 ^ 0) / 2 ^ 0
    
    
End Sub


Private Sub InitGrid()

    Dim i As Integer
    Grid1.Cols = 17
    Grid1.ColWidth(0) = 600
    
    For i = 1 To 16
        Grid1.ColWidth(i) = 200
    Next i
    
    Grid1.Rows = NumberOfSamples \ 10
    
End Sub

Private Sub UpdateGrid()
        
    Dim i As Long
    Dim j As Integer
    Dim k As Integer
    Dim temp As String
    temp = lblStatus.Caption
    
    cmdAcquire.Enabled = False
    lblStatus.Caption = "Updating Data Grid . . .0%"
    k = 0
    
    For i = 0 To NumberOfSamples \ 10 - 1
        If i Mod (NumberOfSamples \ 1000) = 0 Then
            lblStatus.Caption = "Updating Data Grid . . ." + Str(k) + "%"
            k = k + 1
        End If
        Grid1.TextArray(faIndex(i, 0)) = i
        
        For j = 15 To 0 Step -1
            DoEvents
            Grid1.TextArray(faIndex(i, 15 - j + 1)) = Val((DriverLINXSR1.DLVolts2Code(DataArray(0, i)) And (2 ^ j)) / (2 ^ j))
        Next j
    Next i
    lblStatus.Caption = temp
    cmdAcquire.Enabled = True
    
End Sub
Private Function faIndex(ByVal row As Integer, ByVal col As Integer) As Long
    'Quick conversion function (lifted from help file).
    faIndex = row * Grid1.Cols + col
End Function

